///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthProcessCommand(char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;

    char FlaggedData[MaxReceiveSize + 1];
	char SendTemp[MaxReceiveSize + 1];

    if( strcmp(ReceivedData, "::Authentication.Success") == 0)
    {
        return AUTH_CMD_SUCCESS;
    }
    else if( strcmp(ReceivedData, "::Authentication") == 0)
    {
        sprintf(SendTemp, "::Authentication:%s", gsAuthString);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqCompanyName") == 0)
    {
        sprintf(SendTemp, "::CompanyName:%s", gsCompanyName);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqCompanyPassword") == 0)
    {
        sprintf(SendTemp, "::CompanyPassword:%s", gsCompanyPassword);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqClientVersion") == 0)
    {
        sprintf(SendTemp, "::ClientVersion:%s", FileVersion);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::Disconnect") == 0)
    {
        return AUTH_CMD_DISCONNECT;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Error:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        InsertListBoxItem(MDI.RecvEdit_hWnd, FlaggedData, -1);

        return AUTH_CMD_DISCONNECT;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Message:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        InsertListBoxItem(MDI.RecvEdit_hWnd, FlaggedData, -1);

        return AUTH_CMD_OK;
    }

    return AUTH_CMD_UNKNOWN;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthenticateWithServer(void)
{
    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    while(MyClient.Connected)
    {
        if(MyClient.GetReceiveData(ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int AuthCmdResult = AuthProcessCommand(ReceiveData, ReceiveSize);
            if(AuthCmdResult == AUTH_CMD_FAILED)
            {
//                InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_FAILED", -1);
                return AUTH_CMD_FAILED;
            }
            else if(AuthCmdResult == AUTH_CMD_SUCCESS){
//                InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_SUCCESS", -1);
                return AUTH_CMD_SUCCESS;
            }
            else if(AuthCmdResult == AUTH_CMD_DISCONNECT){
//                InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_DISCONNECT", -1);
                return AUTH_CMD_DISCONNECT;
            }
            else if(AuthCmdResult == AUTH_CMD_UNKNOWN){
//                InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_UNKNOWN", -1);
                return AUTH_CMD_UNKNOWN;
            }
            else if(AuthCmdResult == AUTH_CMD_OK){
//                InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_OK", -1);
                // Still authenticating
            }
        }
        else Sleep(1);

        Sleep(1);
    }

//    InsertListBoxItem(MDI.RecvEdit_hWnd, "AUTH_CMD_DISCONNECT ERR", -1);
    return AUTH_CMD_DISCONNECT;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

